from libs.AutoToolsLib import AutoToolsLib
import json
import pypinyin
from unidecode import unidecode

class AutoTools(AutoToolsLib):
    def __init__(self):
        pass

    def FormData(self):
        # 此处编写用户填写表单
        FormData = [
            self.FormControl.PushButton('InputImagePaths', '方块贴图', 'PngPaths', '选择多个png文件...'),
            self.FormControl.PushButton('BehaviorPackPath', '行为包路径', 'FolderPath', '选择文件夹...'),
            self.FormControl.PushButton('ResourcePackPath', '资源包路径', 'FolderPath', '选择文件夹...'),
        ]
        return FormData

    def FormCommit(self, FormData):
        BehaviorPackPath, ResourcePackPath = FormData['BehaviorPackPath'], FormData['ResourcePackPath']
        RunLogic = [
            self.Create.CreateFolder(ResourcePackPath + '/textures/'),
            self.Create.CreateFolder(ResourcePackPath + '/textures/blocks'),
            self.Create.CreateFolder(BehaviorPackPath + '/netease_blocks'),
        ]

        for ImagePath in FormData['InputImagePaths']:
            BlockChineseName = ImagePath.split('/')[-1].split('.')[0]
            BlockName = self.ChineseConvertToPinYin(BlockChineseName)
            RunLogic.append(self.Other.CopyFile(ImagePath, ResourcePackPath + f'/textures/blocks/', f'{BlockName}.png'))
            RunLogic.append(self.MinecraftOrigin.Blocks(ResourcePackPath + '/blocks.json', f'dfm:{BlockName}', {
                "sound": "normal",
                "textures": f'dfm:{BlockName}'
            }))
            RunLogic.append(self.MinecraftOrigin.TerrainTexture(ResourcePackPath + '/textures/terrain_texture.json', f'dfm:{BlockName}', {
                'textures': f'textures/blocks/{BlockName}'
            }))
            RunLogic.append(self.Create.CreateJson(BehaviorPackPath + f'/netease_blocks/dfm_{BlockName}.json', self.GetBehaviorPackBlockJsonDemo(BlockName)))
            RunLogic.append(self.Other.AddLines(ResourcePackPath + f'/texts/zh_CN.lang', f'tile.dfm:{BlockName}.name={BlockChineseName}\n'))
        return RunLogic

    def ChineseConvertToPinYin(self, Chinese):
        # 将中文转换为小写拼音，且不带声调
        PinYinList = pypinyin.lazy_pinyin(Chinese, style=pypinyin.NORMAL)
        PinYinName = ''.join(PinYinList)
        # 转换特殊字符为 ASCII
        PinYin = unidecode(PinYinName)
        return PinYin

    def GetBehaviorPackBlockJsonDemo(self, BlockName):
        """获取行为包自定义方块json"""
        with open('/dfmAutoDev/plugins/CreateCustomBlock/dfm_baiyoulu_zhixian.json', 'r', encoding='utf-8') as f:
            JsonDict = json.load(f)
            JsonDict['minecraft:block']['description']['identifier'] = f'dfm:{BlockName}'
            return JsonDict