from libs.AutoToolsLib import AutoToolsLib
import json

class AutoTools(AutoToolsLib):
    def __init__(self):
        pass

    def FormData(self):
        # 此处编写用户填写表单
        FormData = [
            self.FormControl.PushButton('InputJsonPaths', '行为包自定义方块json', 'JsonPaths', '选择多个json文件...'),
            self.FormControl.ComboBox('RenderMaterial', '渲染材质', None, ['全透明', '半透明', '不透明']),
        ]
        return FormData

    def FormCommit(self, FormData):
        RunLogic = []
        JsonPaths = FormData['InputJsonPaths']
        RenderMaterial = FormData['RenderMaterial']
        RenderMaterialDict = {
            '全透明': 'alpha',
            '半透明': 'blend',
            '不透明': 'opaque',
        }
        RenderMaterialValue = RenderMaterialDict[RenderMaterial]
        for BlockJsonPath in JsonPaths:
            with open(BlockJsonPath, 'r', encoding='utf-8') as f:
                JsonDict = json.load(f)
                JsonDict['minecraft:block']['components']['netease:render_layer'] = {}
                JsonDict['minecraft:block']['components']['netease:render_layer']['value'] = RenderMaterialValue
                RunLogic.append(self.Create.CreateJson(BlockJsonPath, JsonDict))
        
        return RunLogic
