from libs.AutoToolsLib import AutoToolsLib
import json, os

class AutoTools(AutoToolsLib):
    def __init__(self):
        pass

    def FormData(self):
        """创建表单控件，严格遵循框架 API"""
        FormData = [
            self.FormControl.PushButton('InputBlockJson', '方块Json', 'JsonPaths',DefaultValue='选择多个方块Json文件...'),
            self.FormControl.LineEdit('blockCollisionMaxX', '方块的max碰撞盒的x', float, DefaultValue='1.0'),
            self.FormControl.LineEdit('blockCollisionMaxY', '方块的max碰撞盒的y', float, DefaultValue='1.0'),
            self.FormControl.LineEdit('blockCollisionMaxZ', '方块的max碰撞盒的z', float, DefaultValue='1.0'),
            self.FormControl.LineEdit('blockCollisionMinX', '方块的min碰撞盒的x', float, DefaultValue='0.0'),
            self.FormControl.LineEdit('blockCollisionMinY', '方块的min碰撞盒的y', float, DefaultValue='0.0'),
            self.FormControl.LineEdit('blockCollisionMinZ', '方块的min碰撞盒的z', float, DefaultValue='0.0'),
            self.FormControl.LineEdit('blockCategory', '方块的分页', DefaultValue='dfm'),
            self.FormControl.LineEdit('blockGroup', '方块的分组',DefaultValue=''),
            self.FormControl.PushButton('blockGroupFolder', '分组的Json文件夹', 'FolderPath',DefaultValue='选择分组Json文件夹'),
            self.FormControl.LineEdit('blockGroupFolderName', '分组需要创建的Json名,注意!如果文件存在,则可能会覆盖掉', str, DefaultValue='dfm_groups.json'),
            self.FormControl.PushButton('blockGroupJson', '分组的Json模板文件,需要指定分组输出的Json文件夹和输出的Json文件', 'JsonValue',DefaultValue='选择分组Json文件,用于修改,如果是新增可以不指定')
        ]
        return FormData

    def FormCommit(self, FormData):
        RunLogic = []
        block_group_name = FormData['blockGroup'].strip()
        
        # 获取分组JSON数据
        group_data = {'groups': []}
        
        # 优先使用直接选择的分组JSON文件
        if FormData.get('blockGroupJson'):
            group_data = FormData['blockGroupJson']
        else:
            # 使用文件夹路径和文件名组合
            group_folder = FormData.get('blockGroupFolder')  # 文件夹路径
            group_file_name = FormData.get('blockGroupFolderName', 'dfm_groups.json')
            final_group_path = os.path.join(group_folder, group_file_name) if group_folder else None

            # 从文件加载分组数据
            if final_group_path and os.path.exists(final_group_path):
                try:
                    with open(final_group_path, 'r', encoding='utf-8') as f:
                        group_data = json.load(f)
                except Exception as e:
                    print(f"加载分组JSON文件失败: {e}")
                    group_data = {'groups': []}

        for block_json_path in FormData['InputBlockJson']:
            # 读取JSON
            try:
                with open(block_json_path, 'r', encoding='utf-8') as f:
                    block_data = json.load(f)
            except Exception as e:
                print(f"读取方块JSON文件失败: {e}")
                continue
            
            block_id = block_data['minecraft:block']['description']['identifier']
            # 碰撞盒、分类
            block_data.setdefault('minecraft:block', {}).setdefault('netease:aabb', {}).setdefault('collision', {})['max'] = [
                float(FormData['blockCollisionMaxX']),
                float(FormData['blockCollisionMaxY']),
                float(FormData['blockCollisionMaxZ'])
            ]
            block_data['minecraft:block']['netease:aabb']['collision']['min'] = [
                float(FormData['blockCollisionMinX']),
                float(FormData['blockCollisionMinY']),
                float(FormData['blockCollisionMinZ'])
            ]
            block_data['minecraft:block']['description']['category'] = FormData['blockCategory']
            block_data['minecraft:block']['description']['register_to_create_menu'] = True

            # 分组逻辑
            if not block_group_name:
                # 分组名为空，仅保存方块 JSON
                RunLogic.append(
                    self.Create.CreateJson(block_json_path, block_data)
                )
                continue

            # 查找 创建 分组
            groups = group_data.get('groups', [])
            target_group = next(
                (g for g in groups if g.get('group_name') == block_group_name), 
                None
            )

            if target_group:
                # 更新已有分组
                if block_id not in target_group['list']:
                    target_group['list'].append(block_id)
                if not target_group.get('icon'):
                    target_group['icon'] = block_id
            else:
                # 新建分组
                groups.append({
                    'group_name': block_group_name,
                    'icon': block_id,
                    'list': [block_id]
                })

            # 保存修改后的JSON
            RunLogic.append(
                self.Create.CreateJson(block_json_path, block_data)
            )

        # 保存分组 JSON
        if block_group_name and FormData.get('blockGroupFolder'):
            group_folder = FormData['blockGroupFolder']
            group_file_name = FormData.get('blockGroupFolderName', 'dfm_groups.json')
            final_group_path = os.path.join(group_folder, group_file_name)
            
            try:
                os.makedirs(group_folder, exist_ok=True)  # 确保文件夹存在
                with open(final_group_path, 'w', encoding='utf-8') as f:
                    json.dump(group_data, f, ensure_ascii=False, indent=2)
                RunLogic.append(
                    self.Create.CreateJson(final_group_path, group_data)
                )
            except Exception as e:
                pass

        return RunLogic