from libs.AutoToolsLib import AutoToolsLib

class AutoTools(AutoToolsLib):
    def __init__(self):
        pass

    def FormData(self):
        # 此处编写用户填写表单
        FormData = [
            self.FormControl.LineEdit('PluginName', '插件名称'),
            self.FormControl.LineEdit('PluginEnName', '插件英文名称', 'str'),
            self.FormControl.LineEdit('Tag', '插件分类'),
            self.FormControl.LineEdit('Version', '插件版本', None, '1.0.0'),
        ]
        return FormData

    def FormCommit(self, FormData):
        PluginPath = f'/dfmAutoDev/plugins/{FormData['PluginEnName']}'
        RunLogic = [
            self.Create.CreateFolder('/dfmAutoDev/plugins'),
            self.Create.CreateFolder(PluginPath),
            self.Zip.UnZip(PluginPath + '/pluginpack.zip', PluginPath, '/pluginlibs.zip'),
            self.Create.CreateJson(PluginPath + '/manifest.json', {'dafeimian:addon': {'description': {'Name': FormData['PluginName'], 'Icon': 'mdi6.hexagon-slice-6', 'Tag': FormData['Tag'], 'Version': FormData['Version']}}}),
            self.Create.CreatePython(PluginPath + '/__init__.py', []),
            self.Create.CreatePython(PluginPath + '/main.py', [self.GetDemoPluginPython()]),
        ]
        return RunLogic

    def GetDemoPluginPython(self):
        PythonString = f"""\
from libs.AutoToolsLib import AutoToolsLib

class AutoTools(AutoToolsLib):
    def __init__(self):
        pass

    def FormData(self):
        # 此处编写用户填写表单
        FormData = [self.FormControl.LineEdit('PluginName', '插件名称')]
        return FormData

    def FormCommit(self, FormData):
        RunLogic = []
        return RunLogic
"""
        return PythonString